/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.eui.ImageLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;

public class ImageButton
extends ImageLabel
implements MouseListener {
    protected static final int defaultBorderWidth = 2;
    private boolean mouseIsUp = true;
    protected ActionListener actionListener;
    Color darkBorder = new Color(100, 100, 100);
    Color lightBorder = new Color(230, 230, 230);

    public ImageButton() {
        this.margin = 2;
        this.addMouseListener(this);
    }

    public ImageButton(String string) {
        super(string);
        this.margin = 2;
        this.addMouseListener(this);
    }

    public ImageButton(URL uRL) {
        super(uRL);
        this.margin = 2;
        this.addMouseListener(this);
    }

    public ImageButton(Image image) {
        super(image);
        this.margin = 2;
        this.addMouseListener(this);
    }

    public void setBorderWidth(int n) {
        this.margin = n;
    }

    public int getBorderWidth() {
        return this.margin;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawBorder();
    }

    private void drawBorder() {
        Graphics graphics = this.getGraphics();
        int n = this.width;
        int n2 = this.height;
        if (this.mouseIsUp) {
            int n3 = 0;
            while (n3 < this.margin) {
                graphics.setColor(this.darkBorder);
                graphics.drawLine(n3, n2 - n3 - 1, n - n3 - 1, n2 - n3 - 1);
                graphics.drawLine(n - n3 - 1, n2 - n3 - 1, n - n3 - 1, n3);
                graphics.setColor(this.lightBorder);
                graphics.drawLine(n3, n2 - n3 - 1, n3, n3);
                graphics.drawLine(n3, n3, n - n3 - 1, n3);
                ++n3;
            }
            return;
        }
        int n4 = 0;
        while (n4 < this.margin) {
            graphics.setColor(this.darkBorder);
            graphics.drawLine(n4, n2 - n4 - 1, n4, n4);
            graphics.drawLine(n4, n4, n - n4 - 1, n4);
            graphics.setColor(this.lightBorder);
            graphics.drawLine(n4, n2 - n4 - 1, n - n4 - 1, n2 - n4 - 1);
            graphics.drawLine(n - n4 - 1, n2 - n4 - 1, this.width - n4 - 1, n4);
            ++n4;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseIsUp = false;
        this.drawBorder();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsUp = true;
        this.drawBorder();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "do"));
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }
}

